import { useStore } from './store/useStore'
import { Header } from './components/Header'
import { Gallery } from './components/Gallery'
import { Viewer } from './components/Viewer'
import { AnimatePresence, motion } from 'framer-motion'

function App() {
  const { viewMode, selectedModel } = useStore()

  return (
    <div className="min-h-screen flex flex-col">
      <Header />
      
      <main className="flex-1 relative">
        <AnimatePresence mode="wait">
          {viewMode === 'gallery' ? (
            <motion.div
              key="gallery"
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              exit={{ opacity: 0, y: -20 }}
              transition={{ duration: 0.3 }}
              className="h-full"
            >
              <Gallery />
            </motion.div>
          ) : (
            <motion.div
              key="viewer"
              initial={{ opacity: 0 }}
              animate={{ opacity: 1 }}
              exit={{ opacity: 0 }}
              transition={{ duration: 0.3 }}
              className="h-full"
            >
              {selectedModel && <Viewer model={selectedModel} />}
            </motion.div>
          )}
        </AnimatePresence>
      </main>
    </div>
  )
}

export default App


